/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.emt.recipe;

import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.crossmod.thaumcraft.util.ThaumcraftHandler;
import com.google.common.collect.ArrayListMultimap;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class TCRecipeHandler {
    public static final GT_Recipe.GT_Recipe_Map alchemicalConstructHandler = new TCRecipeMap(new HashSet<GT_Recipe>(15000), "bwcm.recipe.alchemicalConstruct", "Industrical Alchemical Construct", null, "gregtech:textures/gui/basicmachines/Default", 2, 1, 2, 0, 1, "", 1, "", true, true);
    static Class aCrucibleRecipeClass;
    static Class aThaumcraftAPI;
    static Field craftingRecipes;
    static Field aCrucibleRecipeField;
    static Field aCrucibleRecipeCatalyst;
    static Field aspects;
    static Field key;

    public static void init() throws IllegalAccessException, InvocationTargetException {
        ArrayList tcCraftingList = (ArrayList)craftingRecipes.get(null);
        HashSet crucibleRecipes = new HashSet();
        for (Object o : tcCraftingList) {
            if (!aCrucibleRecipeClass.isInstance(o)) continue;
            crucibleRecipes.add(o);
        }
        TCRecipeHandler.convertCrucibleRecipesToGTRecipes(crucibleRecipes);
    }

    public static void convertCrucibleRecipesToGTRecipes(HashSet crucibleRecipes) throws IllegalAccessException, InvocationTargetException {
        HashSet<GT_Recipe> ret = new HashSet<GT_Recipe>();
        ArrayListMultimap itemToCircuitConfigMap = ArrayListMultimap.create();
        ArrayListMultimap itemToAspectsMap = ArrayListMultimap.create();
        ArrayListMultimap itemToOutputMap = ArrayListMultimap.create();
        ArrayListMultimap itemToResearchMap = ArrayListMultimap.create();
        for (Object o : crucibleRecipes) {
            String key = (String)TCRecipeHandler.key.get(o);
            ItemStack out = (ItemStack)aCrucibleRecipeField.get(o);
            Object aspects = TCRecipeHandler.aspects.get(o);
            Object cat = aCrucibleRecipeCatalyst.get(o);
            if (cat instanceof ItemStack) {
                itemToAspectsMap.put((Object)((ItemStack)cat), aspects);
                itemToOutputMap.put((Object)((ItemStack)cat), (Object)out);
                itemToResearchMap.put((Object)((ItemStack)cat), (Object)key);
                continue;
            }
            if (cat instanceof String) {
                for (ItemStack stack : OreDictionary.getOres((String)((String)cat))) {
                    itemToAspectsMap.put((Object)stack, aspects);
                    itemToOutputMap.put((Object)stack, (Object)out);
                    itemToResearchMap.put((Object)stack, (Object)key);
                }
                continue;
            }
            if (!(cat instanceof ArrayList) || ((ArrayList)cat).size() <= 0) continue;
            for (ItemStack stack : (ArrayList)cat) {
                itemToAspectsMap.put((Object)stack, aspects);
                itemToOutputMap.put((Object)stack, (Object)out);
                itemToResearchMap.put((Object)stack, (Object)key);
            }
        }
        for (Object o : itemToAspectsMap.keySet()) {
            int j;
            if (o.getItemDamage() == Short.MAX_VALUE) {
                itemToCircuitConfigMap.put(o, (Object)24);
            } else {
                for (j = 1; j <= itemToAspectsMap.get(o).size(); ++j) {
                    itemToCircuitConfigMap.put(o, (Object)(j % 24));
                }
            }
            for (j = 0; j < itemToAspectsMap.get(o).size(); ++j) {
                ret.add(TCRecipeHandler.addRecipes((String)itemToResearchMap.get(o).get(j), (ItemStack)itemToOutputMap.get(o).get(j), itemToAspectsMap.get(o).get(j), o, (Integer)itemToCircuitConfigMap.get(o).get(j)));
            }
        }
        for (GT_Recipe recipe : ret) {
            alchemicalConstructHandler.add(recipe);
        }
    }

    public static GT_Recipe addRecipes(String key, ItemStack out, Object aspects, ItemStack cat, int config) throws InvocationTargetException, IllegalAccessException {
        NBTTagCompound toWrite = new NBTTagCompound();
        ThaumcraftHandler.AspectAdder.writeAspectListToNBT.invoke(aspects, toWrite);
        ItemStack fake = new ItemStack(Items.feather);
        fake.setTagCompound(toWrite);
        fake.setStackDisplayName(key);
        BWRecipes.DynamicGTRecipe recipe = new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{cat, GT_Utility.getIntegratedCircuit((int)config)}, new ItemStack[]{out}, fake, null, null, null, 60, 480, 0);
        return recipe;
    }

    static {
        try {
            aCrucibleRecipeClass = Class.forName("thaumcraft.api.crafting.CrucibleRecipe");
            aThaumcraftAPI = Class.forName("thaumcraft.api.ThaumcraftApi");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            aspects = aCrucibleRecipeClass.getField("aspects");
            key = aCrucibleRecipeClass.getField("key");
            aCrucibleRecipeField = aCrucibleRecipeClass.getDeclaredField("recipeOutput");
            aCrucibleRecipeField.setAccessible(true);
            aCrucibleRecipeCatalyst = aCrucibleRecipeClass.getField("catalyst");
            craftingRecipes = aThaumcraftAPI.getDeclaredField("craftingRecipes");
            craftingRecipes.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    static class TCRecipeMap
    extends GT_Recipe.GT_Recipe_Map {
        public TCRecipeMap(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (this.mRecipeList.isEmpty()) {
                return null;
            }
            if (GregTech_API.sPostloadFinished && this.mMinimalInputItems > 0) {
                if (aInputs == null) {
                    return null;
                }
                int tAmount = 0;
                ItemStack[] itemStackArray = aInputs;
                int n = itemStackArray.length;
                for (int i = 0; i < n; ++i) {
                    ItemStack aInput = itemStackArray[i];
                    if (aInput == null) continue;
                    ++tAmount;
                }
                if (tAmount < this.mMinimalInputItems) {
                    return null;
                }
            }
            if (aNotUnificated) {
                aInputs = GT_OreDictUnificator.getStackArray((boolean)true, (Object[])aInputs);
            }
            if (this.mUsualInputCount > 0 && aInputs != null) {
                for (ItemStack tStack : aInputs) {
                    Object aGivenAspectList;
                    Object aAspectListToCheck;
                    NBTTagCompound givenNBT;
                    NBTTagCompound toCheckNBT;
                    if (tStack == null) continue;
                    Collection tRecipes = (Collection)this.mRecipeItemMap.get(new GT_ItemStack(tStack));
                    if (tRecipes != null) {
                        for (GT_Recipe tRecipe : tRecipes) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs)) continue;
                            toCheckNBT = aSpecialSlot.getTagCompound();
                            givenNBT = ((ItemStack)aRecipe.mSpecialItems).getTagCompound();
                            aAspectListToCheck = null;
                            aGivenAspectList = null;
                            try {
                                aAspectListToCheck = ThaumcraftHandler.AspectAdder.mAspectListClass.newInstance();
                                aGivenAspectList = ThaumcraftHandler.AspectAdder.mAspectListClass.newInstance();
                                ThaumcraftHandler.AspectAdder.readAspectListFromNBT.invoke(aAspectListToCheck, toCheckNBT);
                                ThaumcraftHandler.AspectAdder.readAspectListFromNBT.invoke(aGivenAspectList, givenNBT);
                                if (!TCRecipeMap.containsAspects(aAspectListToCheck, aGivenAspectList)) {
                                    continue;
                                }
                            }
                            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                                e.printStackTrace();
                                return null;
                            }
                            return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                        }
                    }
                    if ((tRecipes = (Collection)this.mRecipeItemMap.get(new GT_ItemStack(GT_Utility.copyMetaData((long)32767L, (Object[])new Object[]{tStack})))) == null) continue;
                    for (GT_Recipe tRecipe : tRecipes) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || !BW_Util.areStacksEqualOrNull((ItemStack)tRecipe.mSpecialItems, aSpecialSlot)) continue;
                        toCheckNBT = aSpecialSlot.getTagCompound();
                        givenNBT = ((ItemStack)aRecipe.mSpecialItems).getTagCompound();
                        aAspectListToCheck = null;
                        aGivenAspectList = null;
                        try {
                            aAspectListToCheck = ThaumcraftHandler.AspectAdder.mAspectListClass.newInstance();
                            aGivenAspectList = ThaumcraftHandler.AspectAdder.mAspectListClass.newInstance();
                            ThaumcraftHandler.AspectAdder.readAspectListFromNBT.invoke(aAspectListToCheck, toCheckNBT);
                            ThaumcraftHandler.AspectAdder.readAspectListFromNBT.invoke(aGivenAspectList, givenNBT);
                            if (!TCRecipeMap.containsAspects(aAspectListToCheck, aGivenAspectList)) {
                                continue;
                            }
                        }
                        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                            e.printStackTrace();
                            return null;
                        }
                        return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                    }
                }
            }
            return null;
        }

        private static boolean containsAspects(Object aAspectListToCheck, Object aGivenAspectList) throws InvocationTargetException, IllegalAccessException {
            Object[] aspects = (Object[])ThaumcraftHandler.AspectAdder.getAspects.invoke(aGivenAspectList, new Object[0]);
            for (int i = 0; i < aspects.length; ++i) {
                if ((Integer)ThaumcraftHandler.AspectAdder.getAmount.invoke(aAspectListToCheck, aspects[i]) >= (Integer)ThaumcraftHandler.AspectAdder.getAmount.invoke(aGivenAspectList, aspects[i])) continue;
                return false;
            }
            return true;
        }
    }
}

